/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.orecruncher.sndctrl.SoundControl;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static final Client CLIENT;
    private static final String CLIENT_CONFIG;
    public static final ForgeConfigSpec SPEC;

    private Config() {
    }

    private static void applyConfig() {
        SoundControl.LOGGER.setDebug((Boolean)Config.CLIENT.logging.enableLogging.get());
        SoundControl.LOGGER.setTraceMask((Integer)Config.CLIENT.logging.flagMask.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Config.applyConfig();
        SoundControl.LOGGER.debug("Loaded config file %s", configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        SoundControl.LOGGER.debug("Config file changed %s", configEvent.getConfig().getFileName());
        Config.applyConfig();
    }

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, SPEC, CLIENT_CONFIG);
    }

    static {
        CLIENT_CONFIG = "dsurround" + File.separator + "sndctrl" + "-client.toml";
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public static final List<String> defaultSoundConfig = ImmutableList.builder().add((Object)"minecraft:entity.sheep.ambient cull").add((Object)"minecraft:entity.chicken.ambient cull").add((Object)"minecraft:entity.cow.ambient cull").add((Object)"minecraft:entity.pig.ambient cull").add((Object)"minecraft:entity.llama.ambient cull").add((Object)"minecraft:entity.wither.spawn cull 10").add((Object)"minecraft:entity.wither.death cull 10").add((Object)"minecraft:entity.ender_dragon.death cull 10").build();
        public static final List<String> defaultStartupSounds = ImmutableList.builder().add((Object)"minecraft:entity.experience_orb.pickup").add((Object)"minecraft:entity.chicken.egg").add((Object)"minecraft:ambient.underwater.exit").build();
        public final Sound sound;
        public final Logging logging;
        public final Effects effects;

        Client(@Nonnull ForgeConfigSpec.Builder builder) {
            this.sound = new Sound(builder);
            this.effects = new Effects(builder);
            this.logging = new Logging(builder);
        }

        public static class Logging {
            public final ForgeConfigSpec.BooleanValue enableLogging;
            public final ForgeConfigSpec.IntValue flagMask;

            Logging(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines how Sound Control logging will behave").push("Logging Options");
                this.enableLogging = builder.comment("Enables/disables debug logging of the mod").translation("sndctrl.cfg.logging.EnableDebug").define("Debug Logging", false);
                this.flagMask = builder.comment("Bitmask for toggling various debug traces").translation("sndctrl.cfg.logging.FlagMask").defineInRange("Debug Flag Mask", 0, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }

        public static class Effects {
            public final ForgeConfigSpec.BooleanValue fixupRandoms;
            public final ForgeConfigSpec.IntValue effectRange;

            Effects(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines parameters for special effects").push("Effect Options");
                this.fixupRandoms = builder.worldRestart().comment("Replace client side Randomizers with faster versions").translation("sndctrl.cfg.effects.Randoms").define("Replace Randoms", true);
                this.effectRange = builder.worldRestart().comment("Block range of entity special effect handling").translation("sndctrl.cfg.effects.BlockRange").defineInRange("Block Range", 24, 16, 64);
                builder.pop();
            }
        }

        public static class Sound {
            public final ForgeConfigSpec.BooleanValue enableEnhancedSounds;
            public final ForgeConfigSpec.BooleanValue enableOcclusionCalcs;
            public final ForgeConfigSpec.BooleanValue enableMonoConversion;
            public final ForgeConfigSpec.IntValue cullInterval;
            public final ForgeConfigSpec.IntValue backgroundThreadWorkers;
            public final ForgeConfigSpec.IntValue streamingSoundCount;
            public final ForgeConfigSpec.BooleanValue occludeWeather;
            public final ForgeConfigSpec.BooleanValue occludeRecords;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> individualSounds;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> startupSoundList;

            Sound(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("General options for defining sound effects").push("Sound Options");
                this.enableEnhancedSounds = builder.worldRestart().comment("Enable sound reverb and filtering").translation("sndctrl.cfg.sound.EnhancedSounds").define("Enable Enhanced Sounds", true);
                this.enableMonoConversion = builder.comment("Enable conversion of stereo sounds to mono format for spacial play").translation("sndctrl.cfg.sound.MonoConversion").define("Enable Stereo to Mono Conversion", true);
                this.enableOcclusionCalcs = builder.comment("Enable sound occlusion calculations (sound muffling when positioned behind blocks)").translation("sndctrl.cfg.sound.Occlusion").define("Enable Sound Occlusion Calculations", true);
                this.streamingSoundCount = builder.worldRestart().comment("Number of streaming sound channels to configure").translation("sndctrl.cfg.sound.StreamingSoundCount").defineInRange("Streaming Sound Count", 10, 8, 16);
                this.occludeWeather = builder.comment("Occlude WEATHER sounds").translation("sndctrl.cfg.sound.OccludeWeather").define("Occlude WEATHER Sounds", false);
                this.occludeRecords = builder.comment("Occlude RECORDS sounds").translation("sndctrl.cfg.sound.OccludeRecords").define("Occlude RECORDS Sounds", false);
                this.individualSounds = builder.comment("Options to configure sounds on an individual basis").translation("sndctrl.cfg.sound.Individual").defineList("Individual Sound Config", defaultSoundConfig, s -> true);
                this.startupSoundList = builder.comment("Possible sounds to play when client reaches main game menu").translation("sndctrl.cfg.sound.StartupSounds").defineList("Startup Sound List", defaultStartupSounds, s -> true);
                this.cullInterval = builder.comment("Ticks between culled sound events (0 to disable culling)").translation("sndctrl.cfg.sound.CullInterval").defineInRange("Sound Culling Interval", 20, 0, 6000);
                this.backgroundThreadWorkers = builder.worldRestart().comment("Number of background threads to handle sound effect calculations (0 is default)").translation("sndctrl.cfg.sound.Threads").defineInRange("Background Workers", 0, 0, 8);
                builder.pop();
            }
        }
    }

    public static class Flags {
        public static final int SOUND_PLAY = 1;
        public static final int BASIC_SOUND_PLAY = 2;
    }
}

